/*****************************************************************************
 *
 *    Adapter.h                                      { Ver 0.01 10/25/96 }
 *
 ****************************************************************************/
/*
 $Workfile: adapter.h $
 $Revision: 1.1 $
 $Date: 2001/01/31 21:36:09 $
 $Author: hal $
 $Modtime: 3/22/00 2:36p $
 $Log: adapter.h,v $
 Revision 1.1  2001/01/31 21:36:09  hal
 Initial checkin of iButton support files.

* 
* 4     4/14/00 10:47a Bvasquez
* Add USB support.
* 
* 1     3/23/00 8:59a Bvasquez
* 
* 3     1/21/00 11:07a Bvasquez
* Add DS2490 defines
* 
* 2     11/30/98 12:10p Tomc
*/

#ifndef SERIAL_DS2480
#define SERIAL_DS2480      0
#endif 

#ifndef PARALLEL_DS1481
#define PARALLEL_DS1481    1
#endif

#ifndef SERIAL_DS1413
#define SERIAL_DS1413      2
#endif

#ifndef USB_DS2490
#define USB_DS2490         3
#endif

#define PARMSET_infinite   0x0E

#define MAX_SERIAL_PORTS   4 
#define MAX_PARALLEL_PORTS 3
#define MAX_USB_PORTS      1 //4
#define MAX_ADAPTER_NUM    9 //12 

#define MAX_DEV_NAME_LEN   30

typedef enum
{
   SearialAdapter,
   ParallelAdapter,
   USBAdapter,
   LastAdapter
}
ADAPTERLIST;

typedef struct _ADAPTERINFO
{
   BYTE Type;
   BYTE Num;
   char DevString[MAX_DEV_NAME_LEN];
}
ADAPTERINFO, *PADAPTERINFO, FAR *LPADAPTERINFO, NEAR *NPADAPTERINFO;

typedef struct _IBHOST
{
   BYTE          AdapterCount;
   LPADAPTERINFO lpAdapter[MAX_ADAPTER_NUM];
}
IBHOST, *PIBHOST, FAR *LPIBHOST, NEAR *NPIBHOST;

typedef struct _IBADDR
{
   BYTE        ROMData[8];
   ADAPTERINFO iBPort;
}
IBADDR, *PIBADDR, FAR *LPIBADDR, NEAR *NPIBADDR;

